unit fHunSpell;
(* ***************************** BEGIN LICENSE BLOCK **********************
 *
 * Copyright (C) 2015
 * Sunil Kumar Arora (digitiger@gmail.com        sunil@healthsevak.com)
 * All Rights Reserved.
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the content of this file maybe used under the terms of either
 * the GNU General Public License Version 2 or later (the "GPL"), or the GNU
 * Lesser General Public License Version 2.1 or later (the "LGPL"), in which
 * case the provisions of the GPL or the LGPL are applicable instead of those
 * above. If you wish to allow use of your version of this file only under the
 * terms of either the GPL or the LGPL, and not to allow others to use your
 * version of this file under the terms of the MPL, indicate your division by
 * deleting the provisions above and replace them with the notice and other
 * provisions required by the GPL or LGPL. If you do not delete the provisions
 * above, a recipient may use your version of this file under the terms of any
 * one of the MPL, the GPL or the LGPL.
 *
 * *********************** END LICENSE BLOCK *********************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, RichEdit, Buttons, ExtCtrls, ShellAPI, 
  skaSpellCheck;

type
  TfrmHunSpell = class(TForm)
    lblDictionary: TLabel;
    btnClose: TButton;
    OpenDialog1: TOpenDialog;
    SpellCheck1: TskaHunSpellChecker;
    edtDictionary: TEdit;
    btnSelectDict: TBitBtn;
    lblDictionariesURL: TLabel;
    RichEdit1: TRichEdit;
    btnStart: TButton;
    pnlMisSpelled: TPanel;
    Label1: TLabel;
    Label4: TLabel;
    lstSuggestions: TListBox;
    edtMisSpeltWordForExtraHint: TEdit;  //required for screenreaders which are MOSTLY colour blind
    btnReplaceWith: TButton;
    btnChangeAll: TButton;
    btnChange: TButton;
    btnAddToDictionary: TButton;
    btnIgnoreAll: TButton;
    btnIgnoreOnce: TButton;
    btnAbort: TButton;
    btnUndo: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnIgnoreOnceClick(Sender: TObject);
    procedure btnIgnoreAllClick(Sender: TObject);
    procedure btnChangeClick(Sender: TObject);
    procedure btnChangeAllClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnSelectDictClick(Sender: TObject);
    procedure edtDictionaryEnter(Sender: TObject);
    procedure btnReplaceWithClick(Sender: TObject);
    procedure btnAddToDictionaryClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnAbortClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnUndoClick(Sender: TObject);
    procedure RichEdit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure UpdateGUI;
    procedure SpellCheck1Abort(Sender: TObject);
    procedure SpellCheck1Start(Sender: TObject);
    procedure SpellCheck1StateChange(const Sender: TObject;
      const State: TSpellState);
    procedure lblDictionariesURLClick(Sender: TObject);
    procedure lstSuggestionsDblClick(Sender: TObject);
  private
    { Private declarations }
    NoEngineOpted: Boolean;
    FSourceControl: TCustomMemo;
    procedure GoToURL(const aURL: String);
  public
    { Public declarations }
    Showhighlight:boolean;
    highlightcolor:TColor;
    HighLightList:TStringlist;
    OldRichEditWndProc: {integer}pointer;
    PRichEditWndProc:pointer;
    class function DoHunSpellCheck(AnEditControl: TCustomMemo): TModalResult;
                                                                      static;
  end;

  Resourcestring
    TX_AFF_NOT_FOUND      = 'Correspong AFF file named not found!'
                          + #13
                          + '  Specify dictionary file whose *.aff is also '
                          + 'present in same directory.' ;
    TX_DIC_FILE_NOT_FOUND = 'Dictionary File for SpellCheck Engine not found!';
    TX_SPELL_COMPLETE     = 'Spell Check Complete';
    TX_SPELL_CANCELLED    = 'Spell Check Aborted'
                          + #13
                          + 'No Changes applied to the original text!';

 Const
   DefaultDicFile =  'dict\en_GB.dic';//  'dict\en-US-OpenMedSpel.dic';
 var
  frmHunSpell: TfrmHunSpell;
  
implementation
{$R *.DFM}


class function TfrmHunSpell.DoHunSpellCheck(AnEditControl: TCustomMemo):
                                                                   TModalResult;
{This function could be invoked from some other form by using this as modalform
without creating the instance of this form in advance}
var
  frm: TfrmHunSpell;
begin
  Result := mrCancel;
  frm:= TfrmHunSpell.create(Application);
  try
    frm.RichEdit1.Text:= AnEditControl.Text;
    frm.FSourceControl := AnEditControl;
    Result := frm.ShowModal;
  finally
    frm.Free;
  end;
end;

 {************ HighLight ***********888}
 procedure TfrmHunSpell.GoToURL(const aURL: String);
begin
if length(trim(aURL)) > 4 then
  ShellExecute(Handle, 'open', PChar(aURL), '', '', SW_NORMAL);
end;

procedure TfrmHunSpell.lblDictionariesURLClick(Sender: TObject);
begin
  GoToURL(TLabel(sender).Caption);
end;

procedure TfrmHunSpell.lstSuggestionsDblClick(Sender: TObject);
begin
if lstSuggestions.ItemIndex >= 0 then
   btnChangeClick(Self);
end;

procedure TfrmHunSpell.RichEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if SpellCheck1.SpellCheckState = ssChecking then
    SpellCheck1.ManualChangeStart;
end;

procedure TfrmHunSpell.RichEdit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if SpellCheck1.SpellCheckState in [ssCancelled, ssCompleted] then
   SpellCheck1.Reopen;
   
 if SpellCheck1.SpellCheckState = ssChecking then
    SpellCheck1.ManualChangeDone;
end;

procedure TfrmHunSpell.SpellCheck1Abort(Sender: TObject);
begin
  UpdateGUI;
end;

procedure TfrmHunSpell.SpellCheck1Start(Sender: TObject);
begin
  UpdateGUI;
end;

procedure TfrmHunSpell.SpellCheck1StateChange(const Sender: TObject;
  const State: TSpellState);
begin
  if State = ssCompleted then
    ShowMessage(TX_SPELL_COMPLETE);
  UpdateGUI;
end;

procedure TfrmHunSpell.UpdateGUI;
var
  Checking: Boolean;
begin
 if  csDestroying in componentstate then
   exit;
  btnStart.Enabled := (SpellCheck1.SpellCheckState in [ssReady, ssCancelled])
                      and (trim(RichEdit1.Text) <> '');

  Checking := SpellCheck1.SpellCheckState = ssChecking;
  pnlMisSpelled.Visible := Checking;
  pnlMisSpelled.Enabled := Checking;
  btnClose.Visible := not Checking;
end;

{************* FormCreate **********}
procedure TfrmHunSpell.btnStartClick(Sender: TObject);
begin
  if SpellCheck1.SpellCheckState <> ssChecking then
   SpellCheck1.CheckSpelling;

  UpdateGUI;
  if (lstSuggestions.Count > 0) and btnChange.Visible and btnChange.Enabled then
      btnChange.SetFocus;
end;

procedure TfrmHunSpell.btnAddToDictionaryClick(Sender: TObject);
begin
  SpellCheck1.AddCustomWord;
end;

procedure TfrmHunSpell.btnReplaceWithClick(Sender: TObject);
begin
   SpellCheck1.CorrectWithMyWord;
end;

procedure TfrmHunSpell.btnAbortClick(Sender: TObject);
begin
  if SpellCheck1.AbortSpellCheck(False) then
    UpdateGUI;
end;

procedure TfrmHunSpell.btnChangeAllClick(Sender: TObject);
begin
  SpellCheck1.ChangeAll;
end;

procedure TfrmHunSpell.btnChangeClick(Sender: TObject);
begin
  SpellCheck1.Change;
end;

procedure TfrmHunSpell.btnCloseClick(Sender: TObject);
begin
 close;
end;

procedure TfrmHunSpell.btnIgnoreAllClick(Sender: TObject);
begin
  SpellCheck1.IgnoreAll;
end;

procedure TfrmHunSpell.btnIgnoreOnceClick(Sender: TObject);
begin
  SpellCheck1.IgnoreOnce;
end;

procedure TfrmHunSpell.btnSelectDictClick(Sender: TObject);
var
  aff: String;
begin
  if OpenDialog1.Execute then
  begin
    if SpellCheck1.DictionaryFileName = OpenDialog1.FileName then
      exit;

    aff := ChangeFileExt(OpenDialog1.FileName, '.aff');
    if not FileExists(aff) then
    begin
      ShowMessage(TX_AFF_NOT_FOUND);
      OpenDialog1.FileName := '';
      btnSelectDictClick(self);
    end
    else
    begin
      if SpellCheck1.SpellCheckState = ssChecking then
        SpellCheck1.AbortSpellCheck(False);
      edtDictionary.Text := OpenDialog1.FileName;
      SpellCheck1.DictionaryFileName := edtDictionary.Text;
      SpellCheck1.AffixFileName := aff;
      SpellCheck1.Open;
    end;
  end;
end;

procedure TfrmHunSpell.btnUndoClick(Sender: TObject);
begin
  inherited;
  SpellCheck1.Undo;
end;

procedure TfrmHunSpell.edtDictionaryEnter(Sender: TObject);
begin
  btnSelectDict.SetFocus;
end;

procedure TfrmHunSpell.FormActivate(Sender: TObject);
begin
  if ( not SpellCheck1.Active) and (not NoEngineOpted) then
  begin
     btnSelectDictClick(self);
     NoEngineOpted := True;
  end;
end;

procedure TfrmHunSpell.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 { if SpellCheck1.SpellCheckState = ssCompleted then
  begin
    ShowMessage(TX_SPELL_COMPLETE) ;
    if Assigned(FSourceControl) then
      FSourceControl.Text := RichEdit1.Text;
  end
  else
        ShowMessage(TX_SPELL_CANCELLED) ;  }
end;

procedure TfrmHunSpell.FormCreate(Sender: TObject);
var
  dicFile: String;
  function affFile: String;
  begin
    Result := ChangeFileExt(dicFile, '.aff');
  end;
begin
  if (SpellCheck1.DictionaryFileName <>  '') then
      dicFile := SpellCheck1.DictionaryFileName
  else
      dicFile := ExtractFilePath(Application.ExeName)+ DefaultDicFile;

  if (FileExists(dicFile)) and (FileExists(affFile)) then
  begin
      SpellCheck1.AffixFileName := affFile;
      edtDictionary.Text := SpellCheck1.DictionaryFileName;
  end
  else
    edtDictionary.Text := TX_Dic_File_Not_Found;

  if edtDictionary.Text = TX_Dic_File_Not_Found then
    btnSelectDictClick(self);
 // SpellCheck1.SourceTextControl := RichEdit1;
 // SpellCheck1.SuggestionList := lstSuggestions;
  //SpellCheck1.MisSpeltWord := Edit2;
  SpellCheck1.Active :=  (SpellCheck1.DictionaryFileName <>  '')
                                                      and FileExists(dicFile);
  UpdateGUI;
end;



end.

